//
// Created by sachetto on 19/03/2021.
//

#include "helper_functions.h"
#include <stdlib.h>
#include "../config_helpers/config_helpers.h"
#include "cnpy.h"

real *loadState(char *file, int modelID){
	
	real *state;
	state = MALLOC_ARRAY_OF_TYPE(real, 43);
	
	cnpy_array a0;
	bool writable0 = false;
	if (cnpy_open(file, writable0, &a0) != CNPY_SUCCESS) {
		cnpy_perror("Unable to load file");
		abort();
	}
	assert(a0.dtype == CNPY_F8); 
	assert(a0.n_dim == 2);
	size_t index0[] = {0, 0};
	for (index0[0] = 0; index0[0] < a0.dims[0]; index0[0] += 1) {
		for (index0[1] = 0; index0[1] < a0.dims[1]; index0[1] += 1) {
			real x0 = cnpy_get_f8(a0, index0);
			cnpy_set_f8(a0, index0, index0[0]+index0[1]);
			if(index0[0] == modelID){state[index0[1]] = x0;}
		}
	}
	if (cnpy_close(&a0) != CNPY_SUCCESS) {
		cnpy_perror("Unable to close file");
		abort();
	}
	
	return state;	
}

struct extra_data_for_HCM* set_HCM_data(struct config *config, uint32_t num_cells){
    
    struct extra_data_for_HCM *extra_data = MALLOC_ONE_TYPE(struct extra_data_for_HCM);
	
    real f = 0.0f;
    GET_PARAMETER_NUMERIC_VALUE_OR_USE_DEFAULT(real, f, config, "f");

    real Ko = 5.0f;
    GET_PARAMETER_NUMERIC_VALUE_OR_USE_DEFAULT(real, Ko, config, "Ko");

    real INaFactor = 1.0f;
    GET_PARAMETER_NUMERIC_VALUE_OR_USE_DEFAULT(real, INaFactor, config, "INaFactor");

    real ICaLFactor = 1.0f;
    GET_PARAMETER_NUMERIC_VALUE_OR_USE_DEFAULT(real, ICaLFactor, config, "ICaLFactor");

    extra_data->INaFactor = INaFactor;
    extra_data->ICaLFactor = ICaLFactor;
    extra_data->Ko = Ko;
    extra_data->f = f;

	extra_data->ISCH = MALLOC_ARRAY_OF_TYPE(real, num_cells);
	extra_data->APEXB = MALLOC_ARRAY_OF_TYPE(real, num_cells);
	extra_data->HCMRE = MALLOC_ARRAY_OF_TYPE(real, num_cells);
	extra_data->CELLT = MALLOC_ARRAY_OF_TYPE(int, num_cells);
	extra_data->FIB = MALLOC_ARRAY_OF_TYPE(int, num_cells);
	
	// PoM
	
	extra_data->ctrlNormEndo = MALLOC_ARRAY_OF_TYPE(real, 43);
	extra_data->ctrlIschEndo = MALLOC_ARRAY_OF_TYPE(real, 43);
	extra_data->hcmNormEndo = MALLOC_ARRAY_OF_TYPE(real, 43);
	extra_data->hcmIschEndo = MALLOC_ARRAY_OF_TYPE(real, 43);
	extra_data->ctrlNormEpi = MALLOC_ARRAY_OF_TYPE(real, 43);
	extra_data->ctrlIschEpi = MALLOC_ARRAY_OF_TYPE(real, 43);
	extra_data->hcmNormEpi = MALLOC_ARRAY_OF_TYPE(real, 43);
	extra_data->hcmIschEpi = MALLOC_ARRAY_OF_TYPE(real, 43);
	
	
	int modelID;
    GET_PARAMETER_NUMERIC_VALUE_OR_USE_DEFAULT(real, modelID, config, "modelID");
	
	real mCaL = 1.0f;
    real mNa = 1.0f;
    real mto = 1.0f;
    real mNaL = 1.0f;
    real mKr = 1.0f;
    real mKs = 1.0f;
    real mK1 = 1.0f;
    real mNaCa = 1.0f;
    real mNaK = 1.0f;
    real mRel = 1.0f;
    real mUp = 1.0f;
	
	// LOADS STATES
	extra_data->ctrlNormEndo = loadState("/scratch/snx3000/jcoleman/ctrlNormEndo.npy", modelID);
	extra_data->ctrlIschEndo = loadState("/scratch/snx3000/jcoleman/ctrlIschEndo.npy", modelID);
	extra_data->hcmNormEndo = loadState("/scratch/snx3000/jcoleman/hcmNormEndo.npy", modelID);
	extra_data->hcmIschEndo = loadState("/scratch/snx3000/jcoleman/hcmIschEndo.npy", modelID);
	extra_data->ctrlNormEpi = loadState("/scratch/snx3000/jcoleman/ctrlNormEpi.npy", modelID);
	extra_data->ctrlIschEpi = loadState("/scratch/snx3000/jcoleman/ctrlIschEpi.npy", modelID);
	extra_data->hcmNormEpi = loadState("/scratch/snx3000/jcoleman/hcmNormEpi.npy", modelID);
	extra_data->hcmIschEpi = loadState("/scratch/snx3000/jcoleman/hcmIschEpi.npy", modelID);
	
		
	// LOADS CURRENT MULTIPLIERS
	char *fn = "/scratch/snx3000/jcoleman/sf_cal1.npy";
	cnpy_array a;
	bool writable = false;
	if (cnpy_open(fn, writable, &a) != CNPY_SUCCESS) {
		cnpy_perror("Unable to load file");
		abort();
	}
	assert(a.dtype == CNPY_F8); 
	assert(a.n_dim == 2);
	size_t index[] = {0, 0};
	
	for (index[0] = 0; index[0] < a.dims[0]; index[0] += 1) {
		for (index[1] = 0; index[1] < a.dims[1]; index[1] += 1) {
			real x = cnpy_get_f8(a, index);
			cnpy_set_f8(a, index, index[0]+index[1]);
			if(index[0] == modelID){
				if(index[1]==0){mCaL=x;}
				else if(index[1]==1){mNa=x;}
				else if(index[1]==2){mto=x;}
				else if(index[1]==3){mNaL=x;}
				else if(index[1]==4){mKr=x;}
				else if(index[1]==5){mKs=x;}
				else if(index[1]==6){mK1=x;}
				else if(index[1]==7){mNaCa=x;}
				else if(index[1]==8){mNaK=x;}
				else if(index[1]==9){mRel=x;}
				else if(index[1]==10){mUp=x;}
			}
		}
	}
	if (cnpy_close(&a) != CNPY_SUCCESS) {
		cnpy_perror("Unable to close file");
		abort();
	}
	
	extra_data->modelID=modelID;
	
	extra_data->mCaL=mCaL;
    extra_data->mNa=mNa;
    extra_data->mto=mto;
    extra_data->mNaL=mNaL;
    extra_data->mKr=mKr;
    extra_data->mKs=mKs;
    extra_data->mK1=mK1;
    extra_data->mNaCa=mNaCa;
    extra_data->mNaK=mNaK;
    extra_data->mRel=mRel;
    extra_data->mUp=mUp;
	
    return extra_data;
}

struct extra_data_for_fibrosis* set_common_schemia_data(struct config *config, uint32_t num_cells) {

    struct extra_data_for_fibrosis *extra_data = MALLOC_ONE_TYPE(struct extra_data_for_fibrosis);

    real atpi = 6.8;
    GET_PARAMETER_NUMERIC_VALUE_OR_USE_DEFAULT(real, atpi, config, "atpi");

    real Ko = 5.4;
    GET_PARAMETER_NUMERIC_VALUE_OR_USE_DEFAULT(real, Ko, config, "Ko");

    real Ki = 138.3;
    GET_PARAMETER_NUMERIC_VALUE_OR_USE_DEFAULT(real, Ki, config, "Ki");

    real GNa_multiplicator = 1.0f;
    GET_PARAMETER_NUMERIC_VALUE_OR_USE_DEFAULT(real, GNa_multiplicator, config, "GNa_multiplicator");

    real GCaL_multiplicator = 1.0f;
    GET_PARAMETER_NUMERIC_VALUE_OR_USE_DEFAULT(real, GCaL_multiplicator, config, "GCaL_multiplicator");

    real INaCa_multiplicator = 1.0f;
    GET_PARAMETER_NUMERIC_VALUE_OR_USE_DEFAULT(real, INaCa_multiplicator, config, "INaCa_multiplicator");

    real Vm_modifier = 0.0f;
    GET_PARAMETER_NUMERIC_VALUE_OR_USE_DEFAULT(real, Vm_modifier, config, "Vm_modifier");

    extra_data->atpi = atpi;
    extra_data->Ko = Ko;
    extra_data->Ki = Ki;
    extra_data->GNa_multiplicator = GNa_multiplicator;
    extra_data->GCaL_multiplicator = GCaL_multiplicator;
    extra_data->INaCa_multiplicator = INaCa_multiplicator;
    extra_data->Vm_modifier = Vm_modifier;
    extra_data->fibrosis = MALLOC_ARRAY_OF_TYPE(real, num_cells);

    return extra_data;
}

struct extra_data_for_torord * set_common_torord_data (struct config *config, uint32_t num_cells) {
    struct extra_data_for_torord *extra_data = MALLOC_ONE_TYPE(struct extra_data_for_torord);

    real INa_Multiplier = 1.0;    
    GET_PARAMETER_NUMERIC_VALUE_OR_USE_DEFAULT(real, INa_Multiplier, config, "INa_Multiplier");

    real ICaL_Multiplier = 1.0;    
    GET_PARAMETER_NUMERIC_VALUE_OR_USE_DEFAULT(real, ICaL_Multiplier, config, "ICaL_Multiplier");

    real Ito_Multiplier = 1.0;    
    GET_PARAMETER_NUMERIC_VALUE_OR_USE_DEFAULT(real, Ito_Multiplier, config, "Ito_Multiplier");

    real INaL_Multiplier = 1.0;    
    GET_PARAMETER_NUMERIC_VALUE_OR_USE_DEFAULT(real, INaL_Multiplier, config, "INaL_Multiplier");

    real IKr_Multiplier = 1.0;    
    GET_PARAMETER_NUMERIC_VALUE_OR_USE_DEFAULT(real, IKr_Multiplier, config, "IKr_Multiplier");

    real IKs_Multiplier = 1.0;    
    GET_PARAMETER_NUMERIC_VALUE_OR_USE_DEFAULT(real, IKs_Multiplier, config, "IKs_Multiplier");

    real IK1_Multiplier = 1.0;    
    GET_PARAMETER_NUMERIC_VALUE_OR_USE_DEFAULT(real, IK1_Multiplier, config, "IK1_Multiplier");

    real IKb_Multiplier = 1.0;    
    GET_PARAMETER_NUMERIC_VALUE_OR_USE_DEFAULT(real, IKb_Multiplier, config, "IKb_Multiplier");

    real INaCa_Multiplier = 1.0;    
    GET_PARAMETER_NUMERIC_VALUE_OR_USE_DEFAULT(real, INaCa_Multiplier, config, "INaCa_Multiplier");

    real INaK_Multiplier = 1.0;    
    GET_PARAMETER_NUMERIC_VALUE_OR_USE_DEFAULT(real, INaK_Multiplier, config, "INaK_Multiplier");

    real INab_Multiplier = 1.0;    
    GET_PARAMETER_NUMERIC_VALUE_OR_USE_DEFAULT(real, INab_Multiplier, config, "INab_Multiplier");

    real ICab_Multiplier = 1.0;    
    GET_PARAMETER_NUMERIC_VALUE_OR_USE_DEFAULT(real, ICab_Multiplier, config, "ICab_Multiplier");

    real IpCa_Multiplier = 1.0;    
    GET_PARAMETER_NUMERIC_VALUE_OR_USE_DEFAULT(real, IpCa_Multiplier, config, "IpCa_Multiplier");

    real ICaCl_Multiplier = 1.0;    
    GET_PARAMETER_NUMERIC_VALUE_OR_USE_DEFAULT(real, ICaCl_Multiplier, config, "ICaCl_Multiplier");

    real IClb_Multiplier = 1.0;    
    GET_PARAMETER_NUMERIC_VALUE_OR_USE_DEFAULT(real, IClb_Multiplier, config, "IClb_Multiplier");

    real Jrel_Multiplier = 1.0;    
    GET_PARAMETER_NUMERIC_VALUE_OR_USE_DEFAULT(real, Jrel_Multiplier, config, "Jrel_Multiplier");

    real Jup_Multiplier = 1.0;    
    GET_PARAMETER_NUMERIC_VALUE_OR_USE_DEFAULT(real, Jup_Multiplier, config, "Jup_Multiplier");

    extra_data->INa_Multiplier = INa_Multiplier;
    extra_data->ICaL_Multiplier = ICaL_Multiplier;
    extra_data->Ito_Multiplier = Ito_Multiplier;
    extra_data->INaL_Multiplier = INaL_Multiplier;
    extra_data->IKr_Multiplier = IKr_Multiplier;
    extra_data->IKs_Multiplier = IKs_Multiplier;
    extra_data->IK1_Multiplier = IK1_Multiplier;
    extra_data->IKb_Multiplier = IKb_Multiplier;
    extra_data->INaCa_Multiplier = INaCa_Multiplier;
    extra_data->INaK_Multiplier = INaK_Multiplier;
    extra_data->INab_Multiplier = INab_Multiplier;
    extra_data->ICab_Multiplier = ICab_Multiplier;
    extra_data->IpCa_Multiplier = IpCa_Multiplier;
    extra_data->ICaCl_Multiplier = ICaCl_Multiplier;
    extra_data->IClb_Multiplier = IClb_Multiplier;
    extra_data->Jrel_Multiplier = Jrel_Multiplier;
    extra_data->Jup_Multiplier = Jup_Multiplier;
    
    extra_data->initial_ss_endo = MALLOC_ARRAY_OF_TYPE(real, 43);
    extra_data->initial_ss_epi = MALLOC_ARRAY_OF_TYPE(real, 43);
    extra_data->initial_ss_mid = MALLOC_ARRAY_OF_TYPE(real, 43);

    // Set the initial conditions (celltype = ENDO)
    extra_data->initial_ss_endo[0]  = -8.890585e+01;
    extra_data->initial_ss_endo[1]  = 1.107642e-02;
    extra_data->initial_ss_endo[2]  = 6.504164e-05;
    extra_data->initial_ss_endo[3]  = 1.210818e+01;
    extra_data->initial_ss_endo[4]  = 1.210851e+01;
    extra_data->initial_ss_endo[5]  = 1.426206e+02;
    extra_data->initial_ss_endo[6]  = 1.426205e+02;
    extra_data->initial_ss_endo[7]  = 1.530373e+00;
    extra_data->initial_ss_endo[8]  = 1.528032e+00;
    extra_data->initial_ss_endo[9]  = 7.455488e-05;
    extra_data->initial_ss_endo[10] = 7.814592e-04;
    extra_data->initial_ss_endo[11] = 8.313839e-01;
    extra_data->initial_ss_endo[12] = 8.311938e-01;
    extra_data->initial_ss_endo[13] = 6.752873e-01;
    extra_data->initial_ss_endo[14] = 8.308255e-01;
    extra_data->initial_ss_endo[15] = 1.585610e-04;
    extra_data->initial_ss_endo[16] = 5.294475e-01;
    extra_data->initial_ss_endo[17] = 2.896996e-01;
    extra_data->initial_ss_endo[18] = 9.419166e-04;
    extra_data->initial_ss_endo[19] = 9.996194e-01;
    extra_data->initial_ss_endo[20] = 5.938602e-01;
    extra_data->initial_ss_endo[21] = 4.799180e-04;
    extra_data->initial_ss_endo[22] = 9.996194e-01;
    extra_data->initial_ss_endo[23] = 6.543754e-01;
    extra_data->initial_ss_endo[24] = -2.898677e-33;
    extra_data->initial_ss_endo[25] = 1.000000e+00;
    extra_data->initial_ss_endo[26] = 9.389659e-01;
    extra_data->initial_ss_endo[27] = 1.000000e+00;
    extra_data->initial_ss_endo[28] = 9.999003e-01;
    extra_data->initial_ss_endo[29] = 9.999773e-01;
    extra_data->initial_ss_endo[30] = 1.000000e+00;
    extra_data->initial_ss_endo[31] = 1.000000e+00;
    extra_data->initial_ss_endo[32] = 4.920606e-04;
    extra_data->initial_ss_endo[33] = 8.337021e-04;
    extra_data->initial_ss_endo[34] = 6.962775e-04;
    extra_data->initial_ss_endo[35] = 8.425453e-04;
    extra_data->initial_ss_endo[36] = 9.980807e-01;
    extra_data->initial_ss_endo[37] = 1.289824e-05;
    extra_data->initial_ss_endo[38] = 3.675442e-04;
    extra_data->initial_ss_endo[39] = 2.471690e-01;
    extra_data->initial_ss_endo[40] = 1.742987e-04;
    extra_data->initial_ss_endo[41] = 5.421027e-24;
    extra_data->initial_ss_endo[42] = 6.407933e-23;

    // Set the initial conditions (celltype = EPI)
    extra_data->initial_ss_epi[0]  = -8.917755e+01;
    extra_data->initial_ss_epi[1]  = 1.288116e-02;
    extra_data->initial_ss_epi[2]  = 5.767956e-05;
    extra_data->initial_ss_epi[3]  = 1.284260e+01;
    extra_data->initial_ss_epi[4]  = 1.284291e+01;
    extra_data->initial_ss_epi[5]  = 1.429114e+02;
    extra_data->initial_ss_epi[6]  = 1.429113e+02;
    extra_data->initial_ss_epi[7]  = 1.812268e+00;
    extra_data->initial_ss_epi[8]  = 1.810520e+00;
    extra_data->initial_ss_epi[9]  = 6.631866e-05;
    extra_data->initial_ss_epi[10] = 7.370422e-04;
    extra_data->initial_ss_epi[11] = 8.366816e-01;
    extra_data->initial_ss_epi[12] = 8.366012e-01;
    extra_data->initial_ss_epi[13] = 6.840260e-01;
    extra_data->initial_ss_epi[14] = 8.363958e-01;
    extra_data->initial_ss_epi[15] = 1.505860e-04;
    extra_data->initial_ss_epi[16] = 5.412669e-01;
    extra_data->initial_ss_epi[17] = 3.043382e-01;
    extra_data->initial_ss_epi[18] = 9.248184e-04;
    extra_data->initial_ss_epi[19] = 9.996371e-01;
    extra_data->initial_ss_epi[20] = 9.996342e-01;
    extra_data->initial_ss_epi[21] = 4.712023e-04;
    extra_data->initial_ss_epi[22] = 9.996371e-01;
    extra_data->initial_ss_epi[23] = 9.996366e-01;
    extra_data->initial_ss_epi[24] = 4.333129e-43;
    extra_data->initial_ss_epi[25] = 1.000000e+00;
    extra_data->initial_ss_epi[26] = 9.485160e-01;
    extra_data->initial_ss_epi[27] = 1.000000e+00;
    extra_data->initial_ss_epi[28] = 9.999339e-01;
    extra_data->initial_ss_epi[29] = 9.999822e-01;
    extra_data->initial_ss_epi[30] = 1.000000e+00;
    extra_data->initial_ss_epi[31] = 1.000000e+00;
    extra_data->initial_ss_epi[32] = 3.086885e-04;
    extra_data->initial_ss_epi[33] = 5.303737e-04;
    extra_data->initial_ss_epi[34] = 6.775197e-04;
    extra_data->initial_ss_epi[35] = 8.264829e-04;
    extra_data->initial_ss_epi[36] = 9.982135e-01;
    extra_data->initial_ss_epi[37] = 9.433146e-06;
    extra_data->initial_ss_epi[38] = 2.730221e-04;
    extra_data->initial_ss_epi[39] = 2.308784e-01;
    extra_data->initial_ss_epi[40] = 1.690386e-04;
    extra_data->initial_ss_epi[41] = -1.103286e-23;
    extra_data->initial_ss_epi[42] = -6.177055e-22;

    // Set the initial conditions (celltype = MCELL)
    extra_data->initial_ss_mid[0]  = -8.924177e+01;
    extra_data->initial_ss_mid[1]  = 1.922391e-02;
    extra_data->initial_ss_mid[2]  = 6.585066e-05;
    extra_data->initial_ss_mid[3]  = 1.503347e+01;
    extra_data->initial_ss_mid[4]  = 1.503401e+01;
    extra_data->initial_ss_mid[5]  = 1.434407e+02;
    extra_data->initial_ss_mid[6]  = 1.434406e+02;
    extra_data->initial_ss_mid[7]  = 1.959747e+00;
    extra_data->initial_ss_mid[8]  = 1.963459e+00;
    extra_data->initial_ss_mid[9]  = 8.177438e-05;
    extra_data->initial_ss_mid[10] = 7.269124e-04;
    extra_data->initial_ss_mid[11] = 8.379059e-01;
    extra_data->initial_ss_mid[12] = 8.377164e-01;
    extra_data->initial_ss_mid[13] = 6.860578e-01;
    extra_data->initial_ss_mid[14] = 8.372100e-01;
    extra_data->initial_ss_mid[15] = 1.487602e-04;
    extra_data->initial_ss_mid[16] = 5.350003e-01;
    extra_data->initial_ss_mid[17] = 2.851164e-01;
    extra_data->initial_ss_mid[18] = 9.208259e-04;
    extra_data->initial_ss_mid[19] = 9.996411e-01;
    extra_data->initial_ss_mid[20] = 5.673539e-01;
    extra_data->initial_ss_mid[21] = 4.691672e-04;
    extra_data->initial_ss_mid[22] = 9.996412e-01;
    extra_data->initial_ss_mid[23] = 6.265825e-01;
    extra_data->initial_ss_mid[24] = -4.922960e-40;
    extra_data->initial_ss_mid[25] = 1.000000e+00;
    extra_data->initial_ss_mid[26] = 9.200354e-01;
    extra_data->initial_ss_mid[27] = 1.000000e+00;
    extra_data->initial_ss_mid[28] = 9.997888e-01;
    extra_data->initial_ss_mid[29] = 9.999665e-01;
    extra_data->initial_ss_mid[30] = 1.000000e+00;
    extra_data->initial_ss_mid[31] = 1.000000e+00;
    extra_data->initial_ss_mid[32] = 5.161178e-04;
    extra_data->initial_ss_mid[33] = 1.189422e-03;
    extra_data->initial_ss_mid[34] = 6.917041e-04;
    extra_data->initial_ss_mid[35] = 8.225453e-04;
    extra_data->initial_ss_mid[36] = 9.979358e-01;
    extra_data->initial_ss_mid[37] = 1.835276e-05;
    extra_data->initial_ss_mid[38] = 5.316232e-04;
    extra_data->initial_ss_mid[39] = 2.650323e-01;
    extra_data->initial_ss_mid[40] = 1.678628e-04;
    extra_data->initial_ss_mid[41] = 2.091039e-25;
    extra_data->initial_ss_mid[42] = 2.438403e-23;

    extra_data->transmurality = MALLOC_ARRAY_OF_TYPE(real, num_cells);

    return extra_data;
}